// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 10, Aufgabe 2
// "Schneiden von Rechtecken"

class Rectangle {
	int x, y;  // top left corner, y-ccordinates increase downwards
	int width;
	int height;
}

public class A2 {
	
	static int min(int a, int b) {
		if (a > b) return b; else return a;
	}
	
	static int max(int a, int b) {
		if (a > b) return a; else return b;
	}
	
	// Read x, y, width and height of a rectangle
	static Rectangle readRect() {
		Rectangle r = new Rectangle();
		r.x = In.readInt();
		r.y = In.readInt();
		r.width = In.readInt();
		r.height = In.readInt();
		if (In.done()) return r; else return null;
	}
	
	// Print the data of a rectangle
	static void printRect(Rectangle r) {
		Out.print("(" + r.x + "," + r.y + "," + r.width + "," + r.height + ")");
	}
	
	// Return the intersection of r1 and r2 or null if they don't intersect
	static Rectangle intersection(Rectangle r1, Rectangle r2) {
		Rectangle r = new Rectangle();
		r.x = max(r1.x, r2.x);
		r.y = max(r1.y, r2.y);
		int right = min(r1.x + r1.width, r2.x + r2.width);
		int bottom = min(r1.y + r1.height, r2.y + r2.height);
		if (right > r.x && bottom > r.y) {
			r.width = right - r.x;
			r.height = bottom - r.y;
			return r;
		} else
			return null;
	}
	
	public static void main(String args[]) {
		In.open("input.txt");
		Rectangle r1 = readRect();
		while (r1 != null) {
			Rectangle r2 = readRect();
			printRect(r1); Out.print(", "); printRect(r2);
			Rectangle r3 = intersection(r1, r2);
			if (r3 == null) Out.println(": schneiden sich nicht");
			else { Out.print(": Schnittrechteck = "); printRect(r3); Out.println(); }
			r1 = readRect();
		}
		In.close();
	}
}

/*
Sample input:
0 0 10 10 3 3 7 8
-3 5 4 10 0 -1 4 12
0 0 2 2 0 2 3 3
*/
